CREATE OR REPLACE FUNCTION public.ufd_est_prod_tbl_desc_pos_pbm(integer, integer, integer, integer)
RETURNS double precision AS
$body$
 --<<INICIO DO CORPO DA FUNCAO
-- Function: select * from ufd_est_prod_tbl_desc_pos_pbm(1, 2, 3, 4)
/*  
 
 int_cd_emp          --- CODIGO DA EMPRESA  
 int_cd_filial       --- CODIGO DA FILIAL  
 int_cd_prod         --- CODIGO DO PRODUTO  

*/ 

--DECLARA AS VARIAVEIS USADAS NA FUNCAO
DECLARE

---------------------------------------------------------
----DECLARA AS VARIAVEIS QUE ESTAO NO CABECALHO DA FUNCAO
---------------------------------------------------------
in_cd_emp              ALIAS FOR $1;
in_cd_filial           ALIAS FOR $2; 
in_cd_prod             ALIAS FOR $3;
int_usa_desconto_propz_ident ALIAS FOR $4;

var_perc_desc          double precision;
---------------------------------------------------------
---FIM
---------------------------------------------------------
BEGIN --INICIO DOS BLOCOS DA FUNCAO
	-------------------------------------------------------------------------------------------------------------------------------
	--DECLARANDO TABELA TEMPORARIA DE RETORNO
	-------------------------------------------------------------------------------------------------------------------------------
	BEGIN
		CREATE TEMPORARY TABLE temp_tab_desc_prod_pos_pbm
		(	
			cd_tbl_desc 		integer,
			tp_desc 			integer,
			perc_desc			double precision,
			tp_nivel			integer,
			dt_ini              timestamp without time zone
		);
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE temp_tab_desc_prod_pos_pbm; -- TRUNCA A TABELA SE ELA JA EXISTIR NA SESSAO.
	END;
	
	-------------------------------------------------------------------------------------------------------------------------------
	--DECLARANDO TABELA QUE RECEBERA AS TBLS VIGENTES
	-------------------------------------------------------------------------------------------------------------------------------
	BEGIN
		CREATE TEMPORARY TABLE rs_tab_ativa_pos_pbm
		(	
			cd_emp 		integer,    
			cd_tbl_desc integer,    
			tp_desc 	integer
		);
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE rs_tab_ativa_pos_pbm; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.
	END;
	
	-------------------------------------------------------------------------------------------------------------------------------
	--DECLARANDO TABELA DE ARVORE MERCADOLOGICA DO PRODUTO
	-------------------------------------------------------------------------------------------------------------------------------
	
	BEGIN
		CREATE TEMPORARY TABLE rs_est_prod_arv_merc_pos_pbm
		(
			cd_emp					integer,
			cd_prod					integer,
			cd_arv_merc_categ		integer,
			cd_arv_merc_linha		integer,
			cd_mc					integer,
			cd_arv_merc_familia		integer,								
			cd_fabric				integer
		);--fim rs_est_prod_arv_merc
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE rs_est_prod_arv_merc_pos_pbm; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.
	END;
	

	-------------------------------------------------------------------------------------------------------------------------------	
	---------------------------------------------------FIM DA CRIACAO DAS TBLS TEMPORARIAS-----------------------------------------
	-------------------------------------------------------------------------------------------------------------------------------

		-------------------------------------------------------------------------------------------------------------------------------
		--BUSCANDO ARVORE MERC. DO PRODUTO
		-------------------------------------------------------------------------------------------------------------------------------	
		INSERT INTO rs_est_prod_arv_merc_pos_pbm		
			SELECT 
				arv.cd_emp					,
				arv.cd_prod					,
				arv.cd_arv_merc_categ		,
				arv.cd_arv_merc_linha		,
				arv.cd_mc					,
				arv.cd_arv_merc_familia		,												
				p.cd_fabric 
			FROM 	est_prod_est_arv_mercadologica arv INNER JOIN est_prod p ON
					arv.cd_emp		= p.cd_emp
					AND arv.cd_prod = p.cd_prod
			WHERE   	arv.cd_emp = in_cd_emp
				AND 	arv.cd_prod = in_cd_prod;

		--raise notice 'cd_arv_merc_linha %', (select cd_arv_merc_linha from rs_est_prod_arv_merc limit 1);

			INSERT INTO rs_tab_ativa_pos_pbm    
				SELECT  a.cd_emp,    
						a.cd_tbl_desc,    
						a.cd_tp_desconto
				FROM	est_prod_tbl_desc a INNER JOIN 
				        est_prod_tbl_desc_prc_filial fil ON    
							a.cd_emp = fil.cd_emp AND    
							a.cd_tbl_desc = fil.cd_tbl_desc 
				WHERE	in_cd_emp = a.cd_emp AND     
                        in_cd_filial = fil.cd_filial AND		
						CURRENT_DATE BETWEEN a.dt_ini AND a.dt_fim AND
						1 = a.sts_tbl_desc AND    
						27 = a.cd_tp_desconto
						AND	(
					      ((int_usa_desconto_propz_ident = 1) AND (a.flag_tp_desconto_propz = 1)) OR 
					      ((int_usa_desconto_propz_ident = 0) AND (a.flag_tp_desconto_propz <> 1))
					    );
						
		IF EXISTS (SELECT 1 FROM rs_est_prod_arv_merc_pos_pbm) THEN
			IF EXISTS (SELECT 1 FROM rs_tab_ativa_pos_pbm) THEN
				-------------------------------------------------------------------------------------------------------------------------------    
				--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 1 - PRODUTOS    
				-------------------------------------------------------------------------------------------------------------------------------    
				INSERT INTO temp_tab_desc_prod_pos_pbm     
					  SELECT    
							a.cd_tbl_desc AS cd_tbl_desc,    
							a.cd_tp_desconto AS tp_desc,      
							b.perc_desc AS perc_desc,      
							1 AS tp_nivel,
							a.dt_ini    
					  FROM est_prod_tbl_desc a    
							INNER JOIN est_prod_tbl_desc_est_prod b ON    
								a.cd_emp = b.cd_emp AND    
								a.cd_tbl_desc = b.cd_tbl_desc    
							INNER JOIN est_prod_tbl_desc_prc_filial fil ON    
								b.cd_emp = fil.cd_emp AND    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							INNER JOIN rs_tab_ativa_pos_pbm ON    
								b.cd_emp = rs_tab_ativa_pos_pbm.cd_emp AND    
								b.cd_tbl_desc = rs_tab_ativa_pos_pbm.cd_tbl_desc     
							INNER JOIN rs_est_prod_arv_merc_pos_pbm arv ON    
								b.cd_emp = arv.cd_emp AND    
								b.cd_prod = arv.cd_prod           
					  WHERE     
								in_cd_filial = fil.cd_filial;
								
				-------------------------------------------------------------------------------------------------------------------------------    
				--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 2 - FAMILIAS    
				-------------------------------------------------------------------------------------------------------------------------------    
				INSERT INTO temp_tab_desc_prod_pos_pbm     
					SELECT   
							a.cd_tbl_desc AS cd_tbl_desc,    
							a.cd_tp_desconto AS tp_desc,    
							b.perc_desc AS perc_desc,    
							2 AS tp_nivel,
							a.dt_ini    
					FROM Est_prod_tbl_desc a    
							INNER JOIN est_prod_tbl_desc_est_arv_merc_familia b ON    
								a.cd_emp = b.cd_emp AND    
								a.cd_tbl_desc = b.cd_tbl_desc    
							INNER JOIN est_prod_tbl_desc_prc_filial fil ON    
								b.cd_emp = fil.cd_emp AND    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							INNER JOIN rs_est_prod_arv_merc_pos_pbm arv ON    
								b.cd_emp = arv.cd_emp AND    
								b.cd_arv_merc_familia = arv.cd_arv_merc_familia    
							INNER JOIN rs_tab_ativa_pos_pbm ON    
								a.cd_emp = rs_tab_ativa_pos_pbm.cd_emp AND    
								b.cd_tbl_desc = rs_tab_ativa_pos_pbm.cd_tbl_desc        
					WHERE     
							in_cd_filial = fil.cd_filial;
							
				-------------------------------------------------------------------------------------------------------------------------------        
				--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 3 - MARCAS    
				-------------------------------------------------------------------------------------------------------------------------------    
				INSERT INTO temp_tab_desc_prod_pos_pbm     
					SELECT
							a.cd_tbl_desc AS cd_tbl_desc,    
							a.cd_tp_desconto AS tp_desc,    
							b.perc_desc AS perc_desc,     
							3 AS tp_nivel,
							a.dt_ini    
					FROM est_prod_tbl_desc a    
							INNER JOIN est_prod_tbl_desc_est_mc b ON    
								a.cd_emp = b.cd_emp AND    
								a.cd_tbl_desc = b.cd_tbl_desc    
							INNER JOIN est_prod_tbl_desc_prc_filial fil ON    
								b.cd_emp = fil.cd_emp AND    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							INNER JOIN rs_est_prod_arv_merc_pos_pbm arv ON    
								b.cd_emp = arv.cd_emp AND    
								b.cd_mc = arv.cd_mc    
							INNER JOIN rs_tab_ativa_pos_pbm ON    
								a.cd_emp = rs_tab_ativa_pos_pbm.cd_emp AND    
								b.cd_tbl_desc = rs_tab_ativa_pos_pbm.cd_tbl_desc        
					WHERE     
							in_cd_filial = fil.cd_filial;
							
				-------------------------------------------------------------------------------------------------------------------------------    
				--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 4 - FABRICANTES    
				-------------------------------------------------------------------------------------------------------------------------------    
				INSERT INTO temp_tab_desc_prod_pos_pbm     
					SELECT   
							a.cd_tbl_desc AS cd_tbl_desc,    
							a.cd_tp_desconto AS tp_desc,      
							b.perc_desc AS perc_desc,     
							4 AS tp_nivel,
							a.dt_ini     
					FROM est_prod_tbl_desc a    
							INNER JOIN est_prod_tbl_desc_est_prod_fabric b ON    
								a.cd_emp = b.cd_emp AND    
								a.cd_tbl_desc = b.cd_tbl_desc    
							INNER JOIN est_prod_tbl_desc_prc_filial fil ON    
								b.cd_emp = fil.cd_emp AND    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							INNER JOIN rs_est_prod_arv_merc_pos_pbm arv ON    
								b.cd_emp = arv.cd_emp AND    
								b.cd_fabric = arv.cd_fabric     
							INNER JOIN rs_tab_ativa_pos_pbm ON    
								b.cd_emp = rs_tab_ativa_pos_pbm.cd_emp AND    
								b.cd_tbl_desc = rs_tab_ativa_pos_pbm.cd_tbl_desc        
					WHERE     
							in_cd_filial = fil.cd_filial;
							
				------------------------------------------------------------------------------------------------------------------------------    
				--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 5 - CATEGORIAS         
				-------------------------------------------------------------------------------------------------------------------------------    
				INSERT INTO temp_tab_desc_prod_pos_pbm     
					SELECT   
							a.cd_tbl_desc AS cd_tbl_desc,    
							a.cd_tp_desconto AS tp_desc,    
							b.perc_desc AS perc_desc,    
							5 AS tp_nivel,
							a.dt_ini  
					FROM est_prod_tbl_desc a    
							INNER JOIN est_prod_tbl_desc_est_arv_merc_categoria b ON    
								a.cd_emp = b.cd_emp AND    
								a.cd_tbl_desc = b.cd_tbl_desc    
							INNER JOIN est_prod_tbl_desc_prc_filial fil ON    
								b.cd_emp = fil.cd_emp AND    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							INNER JOIN rs_est_prod_arv_merc_pos_pbm arv ON    
								b.cd_emp = arv.cd_emp AND    
								b.cd_arv_merc_categ = arv.cd_arv_merc_categ    
							INNER JOIN rs_tab_ativa_pos_pbm ON    
								a.cd_emp = rs_tab_ativa_pos_pbm.cd_emp AND    
								b.cd_tbl_desc = rs_tab_ativa_pos_pbm.cd_tbl_desc        
					WHERE     
							in_cd_filial = fil.cd_filial;
							
				-------------------------------------------------------------------------------------------------------------------------------    
				--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 6 - LINHAS
				-------------------------------------------------------------------------------------------------------------------------------    
				INSERT INTO temp_tab_desc_prod_pos_pbm     
					SELECT   
							a.cd_tbl_desc AS cd_tbl_desc,    
							a.cd_tp_desconto AS tp_desc,      
							b.perc_desc AS perc_desc,    
							6 AS tp_nivel,
							a.dt_ini 
					FROM est_prod_tbl_desc a    
							INNER JOIN est_prod_tbl_desc_est_arv_merc_linha b ON    
								a.cd_emp = b.cd_emp AND    
								a.cd_tbl_desc = b.cd_tbl_desc    
							INNER JOIN est_prod_tbl_desc_prc_filial fil ON    
								b.cd_emp = fil.cd_emp and    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							INNER JOIN rs_est_prod_arv_merc_pos_pbm arv ON    
								b.cd_emp = arv.cd_emp AND       
								b.cd_arv_merc_linha = arv.cd_arv_merc_linha    
							INNER JOIN rs_tab_ativa_pos_pbm ON    
								a.cd_emp = rs_tab_ativa_pos_pbm.cd_emp AND    
								b.cd_tbl_desc = rs_tab_ativa_pos_pbm.cd_tbl_desc        
					WHERE     
							in_cd_filial = fil.cd_filial;
				
				
			END IF;	--IF EXISTS (SELECT 1 FROM rs_tab_ativa_pos_pbm) THEN	
		END IF; --IF EXISTS (SELECT 1 FROM rs_est_prod_arv_merc) THEN
	 
	
	 
	-------------------------------------------------------------------------------------------------------------------------------
	-- RETORNANDO DESCONTO LIMITE (RESULTADO DA FUNCAO)
	-------------------------------------------------------------------------------------------------------------------------------



		IF EXISTS (SELECT 1 FROM temp_tab_desc_prod_pos_pbm) THEN

			
			SELECT perc_desc INTO var_perc_desc
					  FROM temp_tab_desc_prod_pos_pbm 
					 ORDER BY dt_ini DESC, tp_nivel ASC, perc_desc DESC LIMIT 1;
		ELSE

			
			var_perc_desc =   COALESCE((SELECT 
										COALESCE(CAST(valor AS double precision), 0) 
									  FROM 
										prc_emp_config 
									  WHERE 
										cd_emp = in_cd_emp AND 
										cd_chave ILIKE 'DESCONTO_POS_PBM') , 0);

		END IF;

		RETURN var_perc_desc / 100.;
	
END; --FIM DOS BLOCOS DA FUNCAO
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
PARALLEL UNSAFE
COST 100;

CREATE OR REPLACE FUNCTION public.ufd_est_prod_tbl_desc_pos_pbm(integer, integer, integer)
RETURNS double precision AS
$body$
BEGIN
  RETURN ufd_est_prod_tbl_desc_pos_pbm($1, $2, $3, 0);
END
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
PARALLEL UNSAFE
COST 100;